%This script generates Fig. 3, composed of two figures:

%Panel A: A histogram showing the frequency with which each possible price is the
%greedy price of AMM 1 in the last episode.

%Panel B: A plot of the mean greedy price of AMM1 over episodes with the dispersion
%around the mean.

%Read the data generated by script_simulation
last_episodes = readmatrix('Data/last_episodes.txt');
av_all_episodes = readmatrix('Data/av_all_episodes.txt');

%Parameters used in the simulation
N=2;
T=1000000;
grid_middle = 8;
grid_size= 69;  
tick= 0.1;      

%% GREEDY PRICE OF PLAYER 1 IN LAST EPISODE - HISTOGRAM

figure(1);
    [C,~,ic] = unique(last_episodes(:,N+1));
    percentages = accumarray(ic, 1) / length(ic) * 100;
    %subplot(N, 1, i); 
    bar(C, percentages);
    %xticks((grid_middle - grid_size*tick):(tick):(grid_middle + grid_size*tick));
    xticks(0:1:15);            % use this line in case of tick=0.1 instead of 1
    xlim([grid_middle - grid_size*tick, grid_middle + grid_size*tick]);
    ylim([0 max(percentages)*1.1]);  % Add 10% space above the highest bar
    ylabel('Percentage (%)')
    xlabel('Greedy price in last episode')

%save png
filename = '/Figures/Fig_3_a.png'; 
saveas(figure(1), [pwd filename]);

close(figure(1))

%% AVERAGE GREEDY PRICE OF PLAYER 1 OVER EPISODES
figure(2)

% plot average greedy prices
% the greedy price of AMM1 is in column N+1
x = (1:T)';
plot(x,av_all_episodes(:,N+1) ,'color',[0.8 0.4 0])
hold on

% plot intervals +/- one sd, with 500 episodes moving average
% the average squared greedy price of AMM1 is in column 4*N+1 (3*N columns
% with A_n, opt_n, Profit_n, one column with a_min, N columns with A_n^2,
% then the column with opt_1^2)
upper = movmean(av_all_episodes(:,N+1) + sqrt(av_all_episodes(:,4*N+2)-av_all_episodes(:,N+1).^2),500);  
lower = movmean(av_all_episodes(:,N+1) - sqrt(av_all_episodes(:,4*N+2)-av_all_episodes(:,N+1).^2),500);  
plot(x,upper)
plot(x,lower)
%highlight the interval
fill([x; flipud(x)], [upper; flipud(lower)], [0.9 0.9 0.9]);

plot(x,av_all_episodes(:,N+1) ,'color',[0.8 0.4 0])

% set legend
legend('', '', 'Average', '$\pm$ 1 s.d.', 'interpreter', 'latex', 'location', 'northeast')
legend('boxoff')
ylabel('Greedy Price')
xlabel('Episodes')

ylim([2,12]);

%hide right and top figure borders
ax = gca;
ax.Box = 'off';

%save png
filename = '/Figures/Fig_3_b.png';
saveas(figure(2), [pwd filename]);

hold off